/*
* @category    Programacion Eventos Formulario TomaMuestras
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmTomaMuestras = Ext.extend(winFrmTomaMuestrasUi, {
    initComponent: function() {
        winFrmTomaMuestras.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        ID_PLANTILLA_CITAS = 0;
        ID_PROFESIONAL_EDIT = 0;
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        Ext.getCmp('gridFormulario').store.load();

        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnRegistrarToma = Ext.getCmp('btnRegistrarToma').on("click",this.RegistrarToma,this);
        var btnImprimirStiker = Ext.getCmp('btnImprimirStiker').on("click",this.ImprimirStiker,this);
        
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    RegistrarToma: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            var pCAS = selections[0].json.CAS;
            if(parseInt(selections[0].json.Estrategia) === 0){
                Ext.Msg.show({
                    title: 'Registrar Toma',
                    msg: 'Esta Seguro que registrar la toma de mestra de: ' + selections[0].json.nomPaciente + ', CAS: ' + selections[0].json.CAS + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            Ext.Ajax.request({
                                url: '../../controlador/transcribirlabo/controlador_tomamuestras.php',
                                params:{
                                    task: 'RADICAR_TOMA',
                                    pCAS: selections[0].json.CAS
                                },
                                success: function(response,options){
                                    window.open ("../../controlador/transcribirlabo/imprimirmarcacion.php?pCAS=" + pCAS,"Stiker Laboratorio CAS: " + pCAS);
                                    Ext.getCmp('gridFormulario').store.load();
                                },
                                failure: function(response,options){
                                    Ext.MessageBox.show({
                                        title: 'Toma de Muestras',
                                        msg: 'Ocurrio un error al radicar la toma de la muestra, vuelva a intentarlo.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                },
                                scope:this //bind the callbacks
                            });
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Toma de Muestras',
                    msg: 'Este registro no esta disponible para la toma de la muestra.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Toma de Muestras',
                msg: 'Debe seleccionar un paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirStiker: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            var pCAS = selections[0].json.CAS;
            if(parseInt(selections[0].json.Estrategia) === 1){
                window.open ("../../controlador/transcribirlabo/imprimirmarcacion.php?pCAS=" + pCAS,"Stiker Laboratorio CAS: " + pCAS);
            }else{
                Ext.MessageBox.show({
                    title: 'Toma de Muestras',
                    msg: 'Este registro no esta disponible para la impresion del stiker.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Toma de Muestras',
                msg: 'Debe seleccionar un paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winTomaMuestrasUi').close();
                }
            }
        });
    }
});

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
