/*
* @category    Formulario Asociar Usuarios del Sistema a Bodega
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAsocUsuariosSistUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Asociar Usuarios del Sistema a IPS ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAsocUsuariosSist',
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        
        st = new StoreIPSxSedexEmpresa();
        st.load({
            params: {
                pSede: ID_SEDE
            }
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAsocUsuario',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/users.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripción',
                                allowBlank: false,
                                emptyText: 'Descripción del Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'IPS',
                                anchor: '100%',
                                allowBlank: false,
                                store: st,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intIPSAsocUsr'
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Asociar Usuario',
                            iconCls: 'btnGuardar',
                            id: 'btn_AsociarIPS'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirAsociarIPS'
                        }
                    ]
                }
            }
        ];
        winAsocUsuariosSistUi.superclass.initComponent.call(this);
    }
});
