/*
* @category    Formulario Grid Usuarios del Sistema
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmUsuariosSistUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Consultorios Ubicaciones ::.',
    id: 'winFrmConsultorios',
    closable:false,
    width:980,
    height:480,
    plain:true,
    autoScroll: true,
    resizable : false,
    y:120,
    //layout: 'fit',
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();

        function renderEstado(value, p, record){
            switch (value){
                case "0":
                    return 'Negado';
                    break;
                default:
                    break;
            }
        }

        var st = new StoreGridUsuariosSist();
        st.load({
            params: {
                paramP1: ID_EMPRESA
            }
        });
        
        this.bbar = mybbar;
        this.items = [
           {
                xtype: 'grid',
                id: 'gridUsuarios',
                store: st,
                anchor: "100%",
                border: false,
                frame: true,
                height: 240,
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdUsuario',
                        id: 'IdUsuario'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Codigo',
                        sortable: false,
                        width: 130,
                        dataIndex: 'CodUsuario',
                        id: 'CodUsuario'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 500,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Profesional Asociado',
                        sortable: false,
                        width: 300,
                        dataIndex: 'NomProfesional',
                        id: 'NomProfesional'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                viewConfig: {
                    getRowClass: function(record, index) {
                        if (record.get('Activo') == '0')
                            return 'Negado';
                        else
                            return;
                    }
                },
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Usuario',
                                iconCls: 'btnAddRow',
                                ref: '../btnAddTipoHorario',
                                id: 'btnAddTipoHorario'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar Usuario',
                                iconCls: 'btnEditRow',
                                ref: '../btnEditTipoHorario',
                                id: 'btnEditTipoHorario'
                            },
                            '->',
                            new Ext.app.SearchField({
                                id: 'qryUsuarioSist',
                                store: st,
                                params: {pEmpresa: Ext.get('idempresa').getValue(), start: 0, limit: 15},
                                ValparamP1: ID_EMPRESA,
                                emptyText: 'Escriba el criterio que desea buscar',
                                width: 120,
                                pLoadGrid: true,
                                pGrid: 'gridUsuariosIPS',
                                parrParam: {params:{pUsuario:0}}
                            })
                        ]
                    }
            },
            {
                xtype: 'grid',
                id: 'gridUsuariosIPS',
                store: 'StoreGridUsuariosSistxIPS',
                anchor: "100%",
                border: false,
                frame: true,
                height: 180,
                title: 'IPS Asociadas al Usuario',
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'IdIPS',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdIps',
                        id: 'IPS'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Activo',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'Activo',
                        id: 'Activo'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'IdUsuario',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdUsuario',
                        id: 'IdUsuario'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'IPS',
                        sortable: false,
                        width: 930,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Asociar IPS',
                                iconCls: 'btnAsociarsUsr',
                                id: 'btnAsociarUsuario'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Asociación',
                                iconCls: 'btnDesasociarsUsr',
                                id: 'btnDesasociarUsuario'
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            },
            {
                xtype: 'grid',
                id: 'gridUsuariosBodegas',
                store: 'StoreGridUsuariosSistxBodegas',
                anchor: "100%",
                border: false,
                frame: true,
                height: 180,
                title: '(Bodegas - Puntos Venta) Asociadas al Usuario',
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'IdBodega',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdBodega',
                        id: 'Bodega'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Activo',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'Activo',
                        id: 'Activo'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'IdUsuario',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdUsuario',
                        id: 'IdUsuario'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Bodega - Punto Venta',
                        sortable: false,
                        width: 930,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Asociar Bodega',
                                iconCls: 'btnAsociarsUsr',
                                id: 'btnAsociarUsuarioBod'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Asociación',
                                iconCls: 'btnDesasociarsUsr',
                                id: 'btnDesasociarUsuarioBod'
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        winFrmUsuariosSistUi.superclass.initComponent.call(this);
    }
});
