/*
* @category    Formulario Usuarios del Sistema
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winUsuariosSistUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Usuarios del Sistema ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winUsuariosSistUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmUsuario',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/users.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intEmpresa',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                width: 130,
                                fieldLabel: 'Codigo',
                                allowBlank: false,
                                id: 'strCodUsuario'
                            },
                            {
                                fieldLabel: 'Contraseña ',
                                id: 'strClaveUsuario',
                                xtype : 'textfield',
                                inputType: 'password',
                                allowBlank: false,
                                emptyText: 'Contraseña',
                                width: 130
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripción',
                                allowBlank: false,
                                emptyText: 'Descripción del Usuario',
                                id: 'strDescripcion'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Perfil',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StorePerfilUsuario',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intPerfilUsuario'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Profesional Asociado',
                                anchor: '100%',
                                allowBlank: true,
                                store: 'StoreProfesionales',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intProfesionalUsuario'
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Activo',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolActivo'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_AdicionarHorario',
                            id: 'btn_AdicionarHorario'
                        },
                        {
                            xtype: 'button',
                            text: 'Modificar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_ModificarHorario',
                            id: 'btn_ModificarHorario'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            ref: '../btn_SalirHorario',
                            id: 'btn_SalirHorario'
                        }
                    ]
                }
            }
        ];
        winUsuariosSistUi.superclass.initComponent.call(this);
    }
});
