/*
* @category    Store Grid Historial Laboral Salud Ocupacional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHistorialLaboral = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHistorialLaboral.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHistorialLaboral',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/saludocupacional.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerHistorialLaboral"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'idConsecutivo' },
                { name: 'idPaciente' },
                { name: 'descEmpresa' },
                { name: 'descCargo' },
                { name: 'descTiempo' },
                { name: 'descRisego' },
                { name: 'descElementos' }
            ])
        }, cfg));
    }
});
new StoreGridHistorialLaboral();
