/*
* @category    Store Control de Signos Vitales Hospitalario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridActividadesAdicionales = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridActividadesAdicionales.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridActividadesAdicionales',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc2014.php',
                method: 'POST'
            }),
            baseParams: {
                task: "ACTIVIDADES_ADICIONALES_LISTAR"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'CAS' },
                { name: 'CASRef' },
                { name: 'Paciente' },
                { name: 'IdProcedimiento' },
                { name: 'CUPS' },
                { name: 'Procedimiento' },
                { name: 'FechaAtencion' },
                { name: 'IdCliente' },
                { name: 'Cliente' },
                { name: 'IdPlan' },
                { name: 'Plan' },
                { name: 'IdSubPlan' },
                { name: 'SubPlan' },
                { name: 'Contrato' },
                { name: 'IdProfesional' },
                { name: 'Profesional' }
            ]),
            sortInfo:{field: 'FechaAtencion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridActividadesAdicionales();

