/*
* @category    Store Administracion de Medicamentos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridAdministracionTratamientos = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridAdministracionTratamientos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridAdministracionTratamientos',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc2013.php',
                method: 'POST'
            }),
            baseParams: {
                task: "LISTAR_ADMINISTRACION_MEDICAMENTOS"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'IdConsecutivoAdministracion' },
                { name: 'Paciente' },
                { name: 'CAS' },
                { name: 'FechaAdministracion' },
                { name: 'HoraAdministracion' },
                { name: 'Servicio' },
                { name: 'DosisAdministrada' },
                { name: 'Cantidad' },
                { name: 'Profesional' }
            ]),
            sortInfo:{field: 'FechaAdministracion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridAdministracionTratamientos();

