/*
* @category    Store Control de Signos Vitales Hospitalario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridControlSignosVitales = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridControlSignosVitales.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridControlSignosVitales',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc2013.php',
                method: 'POST'
            }),
            baseParams: {
                task: "LISTAR_CONTROL_SIGNOS_VITALES"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'ConsecutivoTomaSigno' },
                { name: 'IPS' },
                { name: 'Paciente' },
                { name: 'FechaRegistro' },
                { name: 'HoraRegistro' },
                { name: 'IdProfesional' },
                { name: 'CAS' },
                { name: 'TASistolica' },
                { name: 'TADiastolica' },
                { name: 'FC' },
                { name: 'FR' },
                { name: 'SpO2' },
                { name: 'Temp' },
                { name: 'Glucometria' },
                { name: 'Liquidos_Administrados' },
                { name: 'Liquidos_Eliminacion' },
                { name: 'Liquidos_Balance' },
                { name: 'Deposiciones' },
                { name: 'Observaciones' },
                { name: 'Profesional' }
            ]),
            sortInfo:{field: 'FechaRegistro', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridControlSignosVitales();

