/*
* @category    Store Demanda Inducida HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridDemandaInducidaxPac = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridDemandaInducidaxPac.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridDemandaInducidaxPac',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc2013.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerDemandaInducidaxPaciente"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdConsecutivoReporte'},
                {name: 'Paciente'},
                {name: 'IdProced'},
                {name: 'DescProced'},
                {name: 'Solicitante'},
                {name: 'QuienSolicita'},
                {name: 'FechaSolicitud'},
                {name: 'FechaRealizacion'},
                {name: 'ReporteTxt'},
                {name: 'ReporteVal'},
                {name: 'Clasificacion'},
                {name: 'Observaciones'},
                {name: 'Estado'},
                {name: 'CAS'},
                {name: 'CASReporte'},
                {name: 'ProfeSol'},
                {name: 'Usuario'},
                {name: 'FechAct'}
            ])
        }, cfg));
    }
});
new StoreGridDemandaInducidaxPac();

