/*
* @category    Store Evoluciones Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridEvolucionesxPacienteOfimedical = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridEvolucionesxPacienteOfimedical.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridEvolucionesxPacienteOfimedical',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/ofimedicalhc.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerHistorialxPacienteGral"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Paciente' },
                { name: 'CAS' },
                { name: 'ConsecutivoDetalle' },
                { name: 'idPlantillaHC' },
                { name: 'ConsecutivoHC' },
                { name: 'FechaAtencion' },
                { name: 'HoraApertura' },
                { name: 'HoraCierre' },
                { name: 'Actividad' },
                { name: 'Plantilla' },
                { name: 'Evolucion' },
                { name: 'Barthel' },
                { name: 'Hachinski' },
                { name: 'Lawton' },
                { name: 'Folstein' },
                { name: 'MNA' },
                { name: 'Diagppal' },
                { name: 'Diagrel1' },
                { name: 'DiagRel2' },
                { name: 'DiagRel3' },
                { name: 'Tipodiag' },
                { name: 'Finalidad' },
                { name: 'CausaExterna' },
                { name: 'IdCliente' },
                { name: 'Cliente' },
                { name: 'idProfesional' },
                { name: 'NomProfesional' },
                { name: 'NroAutorizacion' }
            ])
            //sortInfo:{field: 'FechaAtencion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridEvolucionesxPacienteOfimedical();

