/*
* @category    Store Atenciones x Pacientes x Salud Ocupacional HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProcesosxPacienteSaludOcupacional = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProcesosxPacienteSaludOcupacional.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProcesosxPacienteSaludOcupacional',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/saludocupacional.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerHistorialAtencionesSaludOcupacional"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Paciente' },
                { name: 'Profesional' },
                { name: 'CAS' },
                { name: 'ConsecutivoDetalle' },
                { name: 'ConsecutivoHC' },
                { name: 'FechaAtencion' },
                { name: 'Actividad' },
                { name: 'IdCliente' },
                { name: 'Cliente' },
                { name: 'TipoExamen' },
                { name: 'Empresa' },
                { name: 'Concepto' },
                { name: 'Restricciones' },
                { name: 'RECOMENOtros' },
                { name: 'NomProfesional' },
                { name: 'NroAutorizacion' },
                { name: 'IdPlantillaHC' },
                { name: 'Diagppal' },
                { name: 'Diagrel1' },
                { name: 'DiagRel2' },
                { name: 'DiagRel3' }
            ])
            //sortInfo:{field: 'FechaAtencion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProcesosxPacienteSaludOcupacional();

