/*
* @category    Store Historico Peso x Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHisPesoxPac = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHisPesoxPac.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHisPesoxPac',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/controlador_tomasignos.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerHistoricoPesoxPac"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'idConsecutivoSolicitud' },
                { name: 'CAS' },
                { name: 'ConsecutivoHC' },
                { name: 'idConcepto' },
                { name: 'codConcepto' },
                { name: 'descConcepto' },
                { name: 'grupoConcepto' },
                { name: 'tipoConcepto' },
                { name: 'Cantidad' },
                { name: 'Posologia' },
                { name: 'dosisDia' },
                { name: 'notasProveedor' },
                { name: 'Remision' },
                { name: 'VlrUnitario' }
            ])
        }, cfg));
    }
});
new StoreGridHisPesoxPac();

