/*
* @category    Store UAM Necesidades de atencion x Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridNecesidadesAtencion = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridNecesidadesAtencion.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridNecesidadesAtencion',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/controlador_odontologia.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerNecesidadesAtencion"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'IdConsecutivoNecesidad' },
                { name: 'CAS' },
                { name: 'FecSolicitud' },
                { name: 'Paciente' },
                { name: 'Servicio' },
                { name: 'Prioridad' },
                { name: 'NecesidadesAtencion' },
                { name: 'EstadoRegistro' }
            ]),
            sortInfo:{field: 'Prioridad', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridNecesidadesAtencion();

