/*
* @category    Store Plantillas HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridPlantillasHC = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridPlantillasHC.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridPlantillasHC',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/controlador_plantillashc.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "LISTAR"},
            groupField: 'Grupo',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdPlantilla', type: 'int', mapping: 'IdPlantilla'},
                {name: 'CodPlantilla', type: 'int', mapping: 'CodPlantilla'},
                {name: 'NomPlantilla', type: 'string', mapping: 'NomPlantilla'},
                {name: 'RutaPlantilla', type: 'string', mapping: 'RutaPlantilla'},
                {name: 'NomObjeto', type: 'string', mapping: 'NomObjeto'},
                {name: 'Grupo', type: 'string', mapping: 'Grupo'},
                {name: 'RutaRptHC', type: 'string', mapping: 'RutaRptHC'},
                {name: 'RutaRptMx', type: 'string', mapping: 'RutaRptMx'},
                {name: 'RutaRptExa', type: 'string', mapping: 'RutaRptExa'},
                {name: 'RutaRptRem', type: 'string', mapping: 'RutaRptRem'},
                {name: 'RutaFrmMx', type: 'string', mapping: 'RutaFrmMx'},
                {name: 'NomObjetoMx', type: 'string', mapping: 'NomObjetoMx'},
                {name: 'RutaFrmAddMx', type: 'string', mapping: 'RutaFrmAddMx'},
                {name: 'NomObjetoAddMx', type: 'string', mapping: 'NomObjetoAddMx'},
                {name: 'RutaFrmExa', type: 'string', mapping: 'RutaFrmExa'},
                {name: 'NomObjetoExa', type: 'string', mapping: 'NomObjetoExa'},
                {name: 'RutaFrmRem', type: 'string', mapping: 'RutaFrmRem'},
                {name: 'NomObjetoRem', type: 'string', mapping: 'NomObjetoRem'},
                {name: 'RutaFrmExa', type: 'string', mapping: 'RutaFrmAddExa'},
                {name: 'NomObjetoExa', type: 'string', mapping: 'NomObjetoAddExa'},
                {name: 'RutaFrmRem', type: 'string', mapping: 'RutaFrmAddRem'},
                {name: 'UsaTestBarthel', type: 'string', mapping: 'UsaTestBarthel'},
                {name: 'UsaTestFolstein', type: 'string', mapping: 'UsaTestFolstein'},
                {name: 'UsaTestHachinski', type: 'string', mapping: 'UsaTestHachinski'},
                {name: 'UsaTestLawton', type: 'string', mapping: 'UsaTestLawton'},
                {name: 'UsaTestYesavage', type: 'string', mapping: 'UsaTestYesavage'}
            ])
        }, cfg));
    }
});
new StoreGridPlantillasHC();

