/*
* @category    Store Procesos x Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProcesosxPacientePartisalud = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProcesosxPacientePartisalud.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProcesosxPacientePartisalud',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/partisalud.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerProcesosxPacienteSinTerminar"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Paciente' },
                { name: 'CAS' },
                { name: 'ConsecutivoDetalle' },
                { name: 'ConsecutivoHC' },
                { name: 'FechaAtencion' },
                { name: 'Actividad' },
                { name: 'IdCliente' },
                { name: 'Cliente' },
                { name: 'TipoExamen' },
                { name: 'ProcesoActual' },
                { name: 'UbicacionActual' },
                { name: 'ConceptoFinal' },
                { name: 'ConceptoFonoaudiologia' },
                { name: 'ConceptoLaboratorio' },
                { name: 'ConceptoTomaSignos' },
                { name: 'ConceptoMedicoOcupacional' },
                { name: 'idProfesional' },
                { name: 'NomProfesional' },
                { name: 'NroAutorizacion' }
            ])
            //sortInfo:{field: 'FechaAtencion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProcesosxPacientePartisalud();

