/*
* @category    Store Resumen Informe Neurodesarrollo
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridInformeFinalNeurodesarrollo = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridInformeFinalNeurodesarrollo.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridInformeFinalNeurodesarrollo',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/evolucionhc.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{
                task: "ver_resumen_neurodesarrollo"
            },
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'ConsecutivoHC' },
                { name: 'Prestador' },
                { name: 'IPS' },
                { name: 'Paciente' },
                { name: 'Cliente' },
                { name: 'Ano' },
                { name: 'Mes' },
                { name: 'Periodo' },
                { name: 'EvaluacionTerapiaFisica' },
                { name: 'ProfesionalTerapiaFisica' },
                { name: 'EvaluacionFonoaudiologia' },
                { name: 'ProfesionalFonoaudiologia' },
                { name: 'EvaluacionTerapiaOcupacional' },
                { name: 'ProfesionalTerapiaOcupacional' },
                { name: 'Conlusiones' },
                { name: 'ProfesionalConclusiones' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'FecNac' },
                { name: 'Edad' },
                { name: 'Genero' },
                { name: 'Direccion' },
                { name: 'Telefono' },
                { name: 'Telefono1' },
                { name: 'profeTerapiaFisicaDoc' },
                { name: 'profeTerapiaFisicaReg' },
                { name: 'profeTerapiaFisicaNom' },
                { name: 'profeTerapiaFonoDoc' },
                { name: 'profeTerapiaFonoReg' },
                { name: 'profeTerapiaFonoNom' },
                { name: 'profeTerapiaOcupaDoc' },
                { name: 'profeTerapiaOcupaReg' },
                { name: 'profeTerapiaOcupaNom' },
                { name: 'profeTerapiaConclusionDoc' },
                { name: 'profeTerapiaConclusionReg' },
                { name: 'profeTerapiaConclusionNom' }
            ])
        }, cfg));
    }
});
new StoreGridInformeFinalNeurodesarrollo();

