/*
* @category    Store Grid Horarios Disponibles x Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHoarariosxAgendaDisponiblesCitas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHoarariosxAgendaDisponiblesCitas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHoarariosxAgendaDisponiblesCitas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "VER_HORARIOSDISP_ALUMA"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'Hora'},
                {name: 'Minutos'},
                {name: 'citaID'},
                {name: 'HoraInicial'},
                {name: 'HoraFinal'},
                {name: 'citaDescripcion'},
                {name: 'IdCita'},
                {name: 'TipoHorario'},
                {name: 'citaGrupoPrioritario'},
                {name: 'citaAsignarWeb'},
                {name: 'citaObservacionesPlantilla'},
                {name: 'citaInfoAdd'},
                {name: 'GrupoCita'},
                {name: 'MostrarGrupoCita'},
                {name: 'AsignarWeb', type: 'bool'},
                {name: 'Seleccionar', type: 'bool'},
                {name: 'citaInfoAdd', type: 'string'},
                {name: 'Estado'},
                {name: 'IdRegistro'},
                {name: 'HoraCitaInicio'},
                {name: 'HoraCitaFin'},
                {name: 'intHoraCitaInicio'},
                {name: 'intHoraCitaFin'}
            ]),
            sortInfo:{field: 'IdCita', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridHoarariosxAgendaDisponiblesCitas();

