/*
* @category    Store Grid Horarios Disponibles x Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHoarariosxAgendaDisponiblesSesiones = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHoarariosxAgendaDisponiblesSesiones.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHoarariosxAgendaDisponiblesSesiones',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "LISTAR_HORARIOS_AGENDAS_DISPONIBLES_SESIONES_CRI"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'idAgenda'
                },
                {
                    name: 'idProfesional'
                },
                {
                    name: 'idIPS'
                },
                {
                    name: 'idConsultorio'
                },
                {
                    name: 'fecAgenda'
                },
                {
                    name: 'citaID'
                },
                {
                    name: 'Estado'
                },
                {
                    name: 'Consultorio'
                },
                {
                    name: 'IdCita'
                },
                {
                    name: 'citaDescripcion'
                },
                {
                    name: 'DesImprime'
                },
                {
                    name: 'HoraAtencion'
                },
                {
                    name: 'GrupoPrioritario',
                    type: 'bool'
                },
                {
                    name: 'AsignarWeb',
                    type: 'bool'
                },
                {
                    name: 'Seleccionar',
                    type: 'bool'
                },
                {
                    name: 'citaInfoAdd',
                    type: 'string'
                },
                {
                    name: 'TipoHorario'
                },
                {
                    name: 'infoPaciente'
                },
                {
                    name: 'infoObservaciones'
                },
                {
                    name: 'CAS'
                }
            ])
        }, cfg));
    }
});
new StoreGridHoarariosxAgendaDisponiblesSesiones();

