/*
* @category    Store Grid Agendas Bloqueadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreAgendasBloqueadas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreAgendasBloqueadas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreAgendasBloqueadas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas.php',
                method: 'POST'
            }),
            autoLoad: false,
            baseParams:{task: "LISTAR_AGENDAS_BLOQUEADAS"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'agendaID'},
                {name: 'agendaFecha'},
                {name: 'agendaUsuario'}
            ]),
            sortInfo:{field: 'agendaFecha', direction: "ASC"}
        }, cfg));
    }
});
new StoreAgendasBloqueadas();

