/*
* @category    Store Grid Citas x Evolucionar
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridCitasxEvolucionar = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridCitasxEvolucionar.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridCitasxEvolucionar',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams: {
                task: "AGENDA_MANUAL_EVOLUCIONAR_ASOTRANSCAL"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'CAS' },
                { name: 'ConsecutivoHC' },
                { name: 'IdAgendaManual' },
                { name: 'Prestador' },
                { name: 'IPS' },
                { name: 'Profesional' },
                { name: 'FecCita' },
                { name: 'codCita' },
                { name: 'OrdenCita' },
                { name: 'HoraCita' },
                { name: 'HoraCitaInfAdd' },
                { name: 'Paciente' },
                { name: 'Cliente' },
                { name: 'IdProced' },
                { name: 'Observaciones' },
                { name: 'EstadoReg' },
                { name: 'ObservacionesEstado' },
                { name: 'Usuario' },
                { name: 'FechaAct' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'FecNac' },
                { name: 'Edad' },
                { name: 'Genero' },
                { name: 'Direccion' },
                { name: 'Telefono' },
                { name: 'Telefono1' },
                { name: 'Email' },
                { name: 'DeptoMunici' },
                { name: 'CodProced' },
                { name: 'DesProced' },
                { name: 'Cliente' },
                {name: 'MarcaExenta'},
                {name: 'idCliente'},
                {name: 'idPlan'},
                {name: 'idSubPlan'},
                {name: 'idContrato'},
                {name: 'Plan'},
                {name: 'SubPlan'},
                {name: 'Contrato'},
                {name: 'IdProcedimiento'},
                {name: 'CodProcedimiento'},
                {name: 'Actividad'},
                {name: 'Agendado'},
                {name: 'YaLegalizado'},
                {name: 'HoraAgenda'},
                {name: 'HoraAtencion'},
                {name: 'FechaLegaliza'},
                {name: 'TipoLegalizacion'},
                {name: 'Zona'},
                {name: 'TipoAfiliacion'},
                {name: 'TipoAfiliado'},
                {name: 'Parentesco'},
                {name: 'RangoSalarial'},
                {name: 'EstadoListado'},
                {name: 'IdPrograma'},
                {name: 'Programa'},
                {name: 'FacturarParticular'},
                {name: 'Exento'},
                {name: 'Tutela'}
            ]),
            sortInfo:{field: 'OrdenCita', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridCitasxEvolucionar();

