/*
* @category    Store Grid Historial Citas Asignadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHistorialCitas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHistorialCitas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHistorialCitas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas.php',
                method: 'POST'
            }),
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'idPaciente'},
                {name: 'FecCita', type: 'date', dateFormat: 'd/m/Y'},
                {name: 'DesCita'},
                {name: 'DescAdiHora'},
                {name: 'Ubicacion'},
                {name: 'CAS', type: 'int'},
                {name: 'Profesional'},
                {name: 'Cliente'},
                {name: 'DescProcedimiento'},
                {name: 'Estado'},
                {name: 'UsuarioAsigna'},
                {name: 'FecAsigna'},
                {name: 'ObservacionesAsigna'},
                {name: 'Oportunidad'},
                {name: 'UsuarioInasistencia'},
                {name: 'MotivoCancela'},
                {name: 'UsuarioCancela'},
                {name: 'FechaCancela'}
            ]),
            sortInfo:{field: 'FecCita', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridHistorialCitas();

