/*
* @category    Store Grid Historial Citas Radicadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHistorialCitasxProgramar = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHistorialCitasxProgramar.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHistorialCitasxProgramar',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asignarcitasesp/controlador_programarcx.php', 
                method: 'POST'
            }),
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdRadicaAgendaEspecialista'},
                {name: 'Prestador'},
                {name: 'IPS'},
                {name: 'Paciente'},
                {name: 'TipDoc'},
                {name: 'Documento'},
                {name: 'PrimerNombre'},
                {name: 'SegundoNombre'},
                {name: 'PrimerApellido'},
                {name: 'SegundoApellido'},
                {name: 'Cliente'},
                {name: 'Plan'},
                {name: 'SubPlan'},
                {name: 'Contrato'},
                {name: 'NomCliente'},
                {name: 'NomPlan'},
                {name: 'NomSubPlan'},
                {name: 'FechaRadicado'},
                {name: 'FechaAtendieron'},
                {name: 'CAS'},
                {name: 'Profesional'},
                {name: 'NomProfesional'},
                {name: 'FecCita'},
                {name: 'HoraCita'},
                {name: 'HoraCitaInfAdd'},
                {name: 'IdProced'},
                {name: 'Observaciones'},
                {name: 'Especialidad'},
                {name: 'TipoAtencion'},
                {name: 'EstadoReg'},
                {name: 'UsuarioRadico'},
                {name: 'CodProced'},
                {name: 'DesProced'},
                {name: 'Solicitante'},
                {name: 'Prioritario'},
                {name: 'Diagnostico'},
                {name: 'MarcaServicio'},
                {name: 'MiembroParteCuerpo'},
                {name: 'Autorizacion'},
                {name: 'Seleccionar'}
            ]),
            sortInfo:{field: 'FechaRadicado', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridHistorialCitasxProgramar();

