/*
* @category    Store Grid Historial Citas Legalizadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHistorialLegalizaciones = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHistorialLegalizaciones.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHistorialLegalizaciones',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas.php',
                method: 'POST'
            }),
            groupField: 'NroAutorizacion',
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'Prestador'},
                {name: 'IPS'},
                {name: 'Paciente'},
                {name: 'CAS'},
                {name: 'MarcaExenta'},
                {name: 'CAS'},
                {name: 'FechaCita'},
                {name: 'Cliente'},
                {name: 'Profesional'},
                {name: 'Ubicacion'},
                {name: 'Actividad'},
                {name: 'HoraAgenda'},
                {name: 'HoraAtencion'},
                {name: 'NroAutorizacion'},
                {name: 'UsuarioLegalizo'},
                {name: 'Prefijo'},
                {name: 'NroDocumento'},
                {name: 'FechaDocumento'},
                {name: 'VlrNeto'},
                {name: 'TipoLegalizacion'}
            ]),
            sortInfo:{field: 'FechaDocumento', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridHistorialLegalizaciones();
