/*
* @category    Store Grid Historial Citas Legalizadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridHistorialOtrosPagos =  Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridHistorialOtrosPagos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridHistorialOtrosPagos',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/controlador_odontologia.php',
                method: 'POST'
            }),
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'idConceptoCobro'},
                {name: 'IPS'},
                {name: 'Paciente'},
                {name: 'Fecha'},
                {name: 'CAS_REF'},
                {name: 'Concepto'},
                {name: 'Cliente'},
                {name: 'NomCliente'},
                {name: 'VlrConcepto'},
                {name: 'Prefijo'},
                {name: 'NroDocumento'},
                {name: 'FechaDocumento'},
                {name: 'idLegalizacion'}
            ]),
            sortInfo:{field: 'FechaDocumento', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridHistorialOtrosPagos();
