/*
* @category    Store IPS x Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridIPSClientes = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridIPSClientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridIPSClientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/clientes/controlador_clientes.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_GRID_IPS"},
            groupField: 'Sede',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdCliente'},
                {name: 'IdSede'},
                {name: 'Sede'},
                {name: 'Descripcion'},
                {name: 'codIPSCliente'},
                {name: 'Activo'}
            ]),
            sortInfo:{field: 'Sede', direction: "ASC", field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridIPSClientes();

