/*
* @category    Store Planes x Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridPlanesClientes = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridPlanesClientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridPlanesClientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/clientes/controlador_clientes2013.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_GRID_PLANES"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdCliente'},
                {name: 'IdPlan'},
                {name: 'Descripcion'},
                {name: 'ExentoCobro'},
                {name: 'AsignarCita'},
                {name: 'Activo'},
                {name: 'CodRapido'}
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridPlanesClientes();

