/*
* @category    Store SubPlanes x Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridSubPlanesClientes = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridSubPlanesClientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridSubPlanesClientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/clientes/controlador_clientes.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_GRID_SUBPLANES"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdSubPlan'},
                {name: 'IdPlan'},
                {name: 'Descripcion'},
                {name: 'FacturarProcOdo'},
                {name: 'FacturarProcMed'},
                {name: 'FacturarActPyP'},
                {name: 'FacturarActMed'},
                {name: 'AsignarCita'},
                {name: 'Activo'}
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridSubPlanesClientes();

