/*
* @category    Store Consultorios x IPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreConsultoriosxIPS = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreConsultoriosxIPS.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreConsultoriosxIPS',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/combobox/cbconsultoriosxips.php',
                method: 'POST'
            }),
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'rows'
            },
            [
                {
                    name: 'Codigo'
                },
                {
                    name: 'Descripcion'
                }
            ]),
            sortInfo:{field: 'Descripcion', direction: "ASC"}
        }, cfg));
    }
});
new StoreConsultoriosxIPS();

