/*
* @category    Store Tipo Horarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreHorarios = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreHorarios.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreHorarios',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/combobox/cbhorarios.php',
                method: 'POST'
            }),
            autoload: false,
            baseParams:{task: "LISTAR"},
            reader: new Ext.data.JsonReader({
                root: 'rows'
            },
            [
                {
                    name: 'Codigo'
                },
                {
                    name: 'Descripcion'
                },
                {
                    name: 'Prestador'
                },
                {
                    name: 'IdTipoHorario'
                },
                {
                    name: 'IdCita'
                },
                {
                    name: 'DesCita'
                },
                {
                    name: 'DesImprime'
                },
                {
                    name: 'HoraAtencion'
                },
                {
                    name: 'GrupoPrioritario',
                    type: 'bool'
                },
                {
                    name: 'AsignarWeb',
                    type: 'bool'
                },
                {
                    name: 'Seleccionar',
                    type: 'bool'
                }
            ]),
            sortInfo:{field: 'IdCita', direction: "ASC"}
        }, cfg));
    }
});
new StoreHorarios();

