/*
* @category    Store Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridMaestroConceptos = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridMaestroConceptos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridMaestroConceptos',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/conceptos/controlador_conceptos.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            groupField: 'TipoEstudio',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name:'IdProced' },
                { name:'TipoCodificacion' },
                { name:'CodProced' },
                { name:'DesProced' },
                { name:'CUPSCodigo' },
                { name:'CUPSDescripcion' },
                { name:'CodMxMinisterio' },
                { name:'PrincipioActivo' },
                { name:'Presentacion' },
                { name:'FormaFarmaceutica' },
                { name:'Concentracion' },
                { name:'UnidadMedida' },
                { name:'Laboratorio' },
                { name:'NivelProced' },
                { name:'CodigoCUM' },
                { name:'RegistroINVIMA' },
                { name:'CodigoBarras' },
                { name:'EsCX' },
                { name:'UVR' },
                { name:'GrupoQx' },
                { name:'Sexo' },
                { name:'Edadini' },
                { name:'Edadfin' },
                { name:'Cantminimo' },
                { name:'Cantmaximo' },
                { name:'CantidadMaxSol' },
                { name:'MinDiasSol' },
                { name:'DosisMaxPac' },
                { name:'Finalidad' },
                { name:'Dxrequerido' },
                { name:'POS' },
                { name:'EsPyP' },
                { name:'EsMX' },
                { name:'EsAnatomo' },
                { name:'TipoRegProced' },
                { name:'fTipoRegistro' },
                { name:'IdTipoEstudio' },
                { name:'TipoEstudio' },
                { name:'fClasificacion' },
                { name:'Utilizacion' },
                { name:'ConceptoFac' },
                { name:'PreparacionEspecial' },
                { name:'PrefijoArchivo' },
                { name:'ArchivoPlantilla' },
                { name:'NumeralODO' },
                { name:'NumeralPyP' },
                { name:'VlrCosto' },
                { name:'Activo' },
                { name:'Usuario' },
                { name:'FechaAct' },
                { name:'EsLaboratorio' },
                { name:'LabFormato2Cols' },
                { name:'LabInterpretacion' },
                { name:'LabOtros' },
                { name:'LabTecnica' },
                { name:'LabPrintInterpretacion' },
                { name:'LabPrintOtros' },
                { name:'LabPrintTecnica' }
            ]),
            sortInfo:{field: 'CodProced', direction: "ASC", field: 'DesProced', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridMaestroConceptos();

