/*
* @category    Store Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridMaestroConceptos = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridMaestroConceptos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridMaestroConceptos',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/conceptos/controlador_conceptos.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_MXSPYP"},
            groupField: 'TipoEstudio',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name:'IdProced' },
                { name:'TipoCodificacion' },
                { name:'CodProced' },
                { name:'DesProced' },
                { name:'CUPSCodigo' },
                { name:'CUPSDescripcion' },
                { name:'NivelProced' },
                { name:'CodigoCUM' },
                { name:'RegistroINVIMA' },
                { name:'NombreComercial' },
                { name:'ClasificacionListado' },
                { name:'PrioridadListado' },
                { name:'ClasificacionListado1' },
                { name:'NomLaboratorio' },
                { name:'ClaseBaseTarifa' },
                { name:'RequiereJustificacion' },
                { name:'TxtUnidadEmpaque' },
                { name:'CantidadUnidadEmpaque' },
                { name:'Fraccionable' },
                { name:'Cantminimo' },
                { name:'Cantmaximo' },
                { name:'Finalidad' },
                { name:'Dxrequerido' },
                { name:'POS' },
                { name:'EsPyP' },
                { name:'EsMX' },
                { name:'EsAnatomo' },
                { name:'EsLaboratorio' },
                { name:'LabInterpretacion' },
                { name:'LabPrintInterpretacion' },
                { name:'LabTecnica' },
                { name:'LabPrintTecnica' },
                { name:'LabOtros' },
                { name:'LabPrintOtros' },
                { name:'LabFormato2Cols' },
                { name:'TipoRegProced' },
                { name:'IdTipoEstudio' },
                { name:'Utilizacion' },
                { name:'ConceptoFac' },
                { name:'VlrCosto' },
                { name:'PuntajeSOAT' },
                { name:'Dxrequerido' },
                { name:'TipoEstudio' },
                { name:'Usuario' },
                { name:'FechaAct' }
            ]),
            sortInfo:{field: 'CodProced', direction: "ASC", field: 'DesProced', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridMaestroConceptos();

