/*
* @category    Store Grid Consentimientos Informados por Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridConsentimientosInformadosxPac = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridConsentimientosInformadosxPac.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridConsentimientosInformadosxPac',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/consentimientoinformado/controlador_consentimiento.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerConsentimientosInformadosxPaciente"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdConsecutivoConsentimiento'},
                {name: 'Paciente'},
                {name: 'IdConsentimiento'},
                {name: 'FechaRegistro'},
                {name: 'Responsable'},
                {name: 'Observaciones'},
                {name: 'FirmaAceptacion'},
                {name: 'FechaAceptacion'},
                {name: 'Consentimiento'},
                {name: 'TipoAceptacion'},
                {name: 'Firma'},
                {name: 'NoFirma'},
                {name: 'Foto'},
                {name: 'FotoAnexo'},
                {name: 'Huella'},
                {name: 'Usuario'},
                {name: 'FechaAct'},
                {name: 'NomConsentimiento'},
                {name: 'RutaConsentimiento'},
                {name: 'Titulo'},
                {name: 'IdCodigo'},
                {name: 'IdVersion'},
                {name: 'FechaPublica'},
                {name: 'TipDoc'},
                {name: 'Documento'},
                {name: 'nomPaciente'},
                {name: 'FecNac'},
                {name: 'Edad'}
            ])
        }, cfg));
    }
});
new StoreGridConsentimientosInformadosxPac();

