/*
* @category    Store Odontogramas x Pacientes HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridPlacaBacterianaxPaciente = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridPlacaBacterianaxPaciente.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridPlacaBacterianaxPaciente',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/uam_odontologia.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerControlesPlacaxPaciente"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'IdConsecutivoOdontograma' },
                { name: 'CAS' },
                { name: 'FecReporte' },
                { name: 'Profesional' },
                { name: 'TipoOdontograma' },
                { name: 'TipoDenticion' }
            ]),
            sortInfo:{field: 'FecReporte', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridPlacaBacterianaxPaciente();

