/*
* @category    Store Grid Movimientos Detalle
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridMovimientosDetalle = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridMovimientosDetalle.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridMovimientosDetalle',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/inventario/controlador_inventario.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_ALERTAS"},
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'ConsecutivoDetalleMovimiento'},
                {name: 'IdMovimiento'},
                {name: 'CodProced'},
                {name: 'DesProced'},
                {name: 'Entrada'},
                {name: 'Salida'},
                {name: 'Saldo'},
                {name: 'VlrCompra'}
            ]),
            sortInfo:{field: 'CodProced', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridMovimientosDetalle();

