/*
* @category    Store Incentario Movimientos x Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridItemsSolicitudNOPOS = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridItemsSolicitudNOPOS.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridItemsSolicitudNOPOS',
            autoLoad: false,
            baseParams:{task: "LISTAR_ITEM_NOPOS"},
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/nopos/controlador_nopos.php',
                method: 'POST'
            }),
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name:'IdRegistroDetalle' },
                { name:'IdNOPOS' },
                { name:'TipoServicio' },
                { name:'Descripcion' },
                { name:'Caracter' },
                { name:'CaracterCantidad' },
                { name:'CaracterDias' },
                { name:'Homologo' },
                { name:'HomologoSustituto' },
                { name:'Justificacion' },
                { name:'Evidencia' },
                { name:'Casuistica' }
            ])
        }, cfg));
    }
});
new StoreGridItemsSolicitudNOPOS();

