/*
* @category    Store Grid Actividades PyP Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridActividadesPyPPacientes = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridActividadesPyPPacientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridActividadesPyPPacientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/pacientes/controlador_pacientes_pyp.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_ACTIVIDDESPYPxPAC"},
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'Paciente'},
                {name: 'Genero'},
                {name: 'FecNac'},
                {name: 'Concepto'},
                {name: 'Estado'}
            ])
        }, cfg));
    }
});
new StoreGridActividadesPyPPacientes();

