/*
* @category    Store Grid Alertas Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridAlertasPacientes = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridAlertasPacientes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridAlertasPacientes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/pacientes/controlador_pacientes_kardex.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_ALERTAS"},
            groupField: 'TipoAlerta',
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdAlerta'},
                {name: 'TipoAlerta'},
                {name: 'Alerta'},
                {name: 'Paciente'},
                {name: 'Usuario'},
                {name: 'Fecha'}
            ]),
            sortInfo:{field: 'IdAlerta', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridAlertasPacientes();

