/*
* @category    Store Notificación Reparación
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridDemandaInducida = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridDemandaInducida.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridDemandaInducida',
            proxy: new Ext.data.HttpProxy({
                url:'../../controlador/pacientes/controlador_demanda_inducida.php',
                method: 'POST'
            }),
            baseParams: {
                task: "LISTAR"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [   
               {name:'Consecutivo'},
               {name:'IPS'},
               {name:'Paciente'},
               {name:'TipDoc'},
               {name:'Documento'},
               {name:'PrimerApellido'},
               {name:'SegundoApellido'},
               {name:'PrimerNombre'},
               {name:'SegundoNombre'},
               {name:'FecNac'},
               {name:'Genero'},
               {name:'Direccion'},
               {name:'Telefono'},
               {name:'Telefono1'},
               {name:'TipoRegistro'},
               {name:'FechaContacto'},
               {name:'HoraContacto'},
               {name:'TipoContacto'},
               {name:'ContactoEfectivo'},
               {name:'PersonaContacto'},
               {name:'Parentesco'},
               {name:'ProgramaRemitido'},
               {name:'Programa'},
               {name:'Observacion'},
               {name:'CAS'},
               {name:'FechaEstudio'},
               {name:'Profesional'},
               {name:'FechaAtencion'},
               {name:'RealizaProximoContrato'},
               {name:'ProximoContacto'},
               {name:'MotivoProximoContacto'},
               {name:'Usuario'},
               {name:'NomUsuario'}
            ])
        }, cfg));
    }
});
new StoreGridDemandaInducida();