/*
* @category    Store Grid inasistencias x Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridInasistenciasxPaciente = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridInasistenciasxPaciente.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridInasistenciasxPaciente',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/pacientes/controlador_pacientes.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_INASISTENCIAxPAC2023"},
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'idPaciente'},
                {name: 'FecCita', type: 'date', dateFormat: 'Y-m-d'},
                {name: 'DesCita'},
                {name: 'DescAdiHora'},
                {name: 'Ubicacion'},
                {name: 'CAS'},
                {name: 'Profesional'},
                {name: 'Cliente'},
                {name: 'DescProcedimiento'},
                {name: 'MotivoCancela'},
                {name: 'UsuarioCancela'},
                {name: 'FechaCancela'},
                {name: 'Origen'},
                {name: 'Estado'}
            ]),
            sortInfo:{field: 'FecCita', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridInasistenciasxPaciente();

