/*
* @category    Store Notificación Reparación
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridKardexPaciente = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridKardexPaciente.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridKardexPaciente',
            proxy: new Ext.data.HttpProxy({
                url:'../../controlador/kardex_paciente/controlador_kardex_paciente.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            groupField:'Estado',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id',
                autoLoad:true
            },
            [   
               {name:'IdKardex'},
               {name:'Paciente'},
               {name:'Programa'},
               {name:'Control'},
               {name:'IPS'},
               {name:'Sede'},
               {name:'Prestador'},
               {name:'Cliente'},
               {name:'Fecha_Preinscripcion'},
               {name:'Tipo_Demanda'},
               {name:'Fecha_Cierre'},
               {name:'Causa_Cierre'},
               {name:'Observaciones_Kardex'},
               {name:'Prioridad'},
               {name:'Usuario_Inscribio'},
               {name:'Estado'},
               {name:'NomPrograma'},
               {name:'NomPaciente'},
               {name:'Fecha_Probable'}
            ])
        }, cfg));
    }
});
new StoreGridKardexPaciente();