/*
* @category    Store Grid Seguimiento Pacientes 4505
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridPacientes4505 = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridPacientes4505.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridPacientes4505',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/pacientes/controlador_pacientes_4505.php',
                method: 'POST'
            }),
            baseParams:{
                task: "LISTAR",
                start: 0, 
                limit: 15
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'ConsecutivoRegistro'},
                {name: 'Id4505'},
                {name: 'IPS'},
                {name: 'Cliente'},
                {name: 'ClienteNom'},
                {name: 'Paciente'},
                {name: 'TipoDoc'},
                {name: 'Documento'},
                {name: 'PrimerApellido'},
                {name: 'SegundoApellido'},
                {name: 'PrimerNombre'},
                {name: 'SegundoNombre'},
                {name: 'FecNac'},
                {name: 'Genero'},
                {name: 'CodigoEtnia'},
                {name: 'CodigoOcupacion'},
                {name: 'CodigoNivelEducativo'},
                {name: 'Gestacion'},
                {name: 'SifilisGestacional'},
                {name: 'HipertensionGestacional'},
                {name: 'HipotiroidismoCongenito'},
                {name: 'SintomaticoRespiratorio'},
                {name: 'TuberculosisMultidrogoresistente'},
                {name: 'Lepra'},
                {name: 'ObesidadDesnutricion'},
                {name: 'VictimaMaltrato'},
                {name: 'VictimaViolenciaSexual'},
                {name: 'InfeccionesTrasmisionSexual'},
                {name: 'EnfermedadMental'},
                {name: 'CancerCervix'},
                {name: 'CancerSeno'},
                {name: 'FluorosisDental'},
                {name: 'FechaPeso'},
                {name: 'Peso'},
                {name: 'FechaTalla'},
                {name: 'Talla'},
                {name: 'FechaProbableParto'},
                {name: 'EdadGestacionalNacer'},
                {name: 'VacunaBCG'},
                {name: 'VacunaHepatitisB'},
                {name: 'VacunaPentavalente'},
                {name: 'VacunaPolio'},
                {name: 'VacunaDPT'},
                {name: 'VacunaRotavirus'},
                {name: 'VacunaNeumococo'},
                {name: 'VacunaInfluenciaNinos'},
                {name: 'VacunaFiebreAmarilla'},
                {name: 'VacunaHepatitisA'},
                {name: 'VacunaTripleViral'},
                {name: 'VacunaPapiloma'},
                {name: 'VacunaTD'},
                {name: 'ControlPlaca'},
                {name: 'FechaParto'},
                {name: 'FechaSalidaParto'},
                {name: 'FechaConcejeriaLactancia'},
                {name: 'FechaControlRN'},
                {name: 'FechaPlanificacionFamiliar'},
                {name: 'SuministroMetodoAnticonceptivo'},
                {name: 'FechaSuministroMetodoAnticonceptivo'},
                {name: 'FechaPrenatalPrimeraVez'},
                {name: 'NumeroControlPrenatal'},
                {name: 'FechaultimoControlPrenatal'},
                {name: 'SuministroAcidoFolicoPrenatal'},
                {name: 'SuministroSulfatoFerrosoPrenatal'},
                {name: 'SuministroCarbonatoCalcioPrenatal'},
                {name: 'FechaAgudezaVisual'},
                {name: 'FechaConsultaOftalmologia'},
                {name: 'FechaDiagnosticoDesnutricion'},
                {name: 'FechaConsultaMujerMaltrato'},
                {name: 'FechaConsultaViolenciaSexual'},
                {name: 'FechaConsultaNutricion'},
                {name: 'FechaConsultaPsicologia'},
                {name: 'FechaConsultaCyDPrimeraVez'},
                {name: 'SuministroSulfatoFerrosoMenores'},
                {name: 'SuministroVitaminaAMenores'},
                {name: 'FechaConsultaJovenPrimeraVez'},
                {name: 'FechaConsultaAdultoPrimeraVez'},
                {name: 'PreservativosITS'},
                {name: 'FechaPreTestVIH'},
                {name: 'FechaPostTestVIH'},
                {name: 'DiagnosticoEnfermedadMental'},
                {name: 'FechaAntigenoHepatitisBGestantes'},
                {name: 'ResultadoAntigenoHepatitisBGestantes'},
                {name: 'FechaSifilis'},
                {name: 'ResultadoSifilis'},
                {name: 'FechaElisaVIH'},
                {name: 'ResultadoElisaVIH'},
                {name: 'FechaTSHNeonatal'},
                {name: 'ResultadoTSHNeonatal'},
                {name: 'TamizajeCancerCuelloUterino'},
                {name: 'FechaCitologia'},
                {name: 'ResultadoCitologia'},
                {name: 'CalidadMuestraCitologia'},
                {name: 'CodigoHabilitacionIPSCitologia'},
                {name: 'FechaColposcopia'},
                {name: 'CodigoHabilitacionIPSColposcopia'},
                {name: 'FechaBiosiaCervical'},
                {name: 'ResultadoBiopsiaCervical'},
                {name: 'CodigoHabilitacionIPSBiosiaCervical'},
                {name: 'FechaMamografia'},
                {name: 'ResultadoMamografia'},
                {name: 'CodigoHabilitacionIPSMamografia'},
                {name: 'FechaTomaBiopsiaSenoBACAF'},
                {name: 'FechaResultadoBiosiaSeno'},
                {name: 'ResultadoBiopsiaSeno'},
                {name: 'CodigoHabilitacionIPSBiopsiaSeno'},
                {name: 'FechaHemoglogina'},
                {name: 'ResultadoHemoglobina'},
                {name: 'FechaGlicemia'},
                {name: 'FechaCreatinina'},
                {name: 'ResultadoCreatinina'},
                {name: 'FechaHemoglobinaGlicosilada'},
                {name: 'ResultadoHemoglobinaGlicosilada'},
                {name: 'FechaMicroalbuminuria'},
                {name: 'FechaColesterolHDL'},
                {name: 'FechaBaciloscopiaDiagnostica'},
                {name: 'ResultadoBaciloscopiaDiagnostica'},
                {name: 'TtoHipotiroidismoCongenito'},
                {name: 'TtoSifilisGestacional'},
                {name: 'TtoSifilisCongenito'},
                {name: 'TtoLepra'},
                {name: 'FechaTerminacionTtoLeishmaniasis'},
                {name: 'Observaciones'},
                {name: 'UsuarioAct'},
                {name: 'FechaAct'},
                {name: 'EstadoPaciente,'},
                {name: 'Estado'}
            ]),
            sortInfo:{field: 'ConsecutivoRegistro', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridPacientes4505();

