/*
* @category    Store Liquidacion Valores CAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


StoreLegalizacionesxCAS = Ext.extend(Ext.data.JsonStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreLegalizacionesxCAS.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreLegalizacionesxCAS',
            url: '../../controlador/posoptica/legalizacionpos.php',
            baseParams: {
                PROCESO: 'VerMovimientosxCAS'
            },
            root: 'rows',
            autoLoad: false,
            fields: [
                { name: 'idLegalizacion' },
                { name: 'Prestador' },
                { name: 'Sede' },
                { name: 'IPS' },
                { name: 'Cliente' },
                { name: 'Plan' },
                { name: 'SubPlan' },
                { name: 'Contrato' },
                { name: 'NomCliente' },
                { name: 'TipoDocumento' },
                { name: 'TipoLegalizacion' },
                { name: 'FechaLegalizacion' },
                { name: 'Naturaleza' },
                { name: 'idLegalizacionCruce' },
                { name: 'Prefijo' },
                { name: 'NroDocumento' },
                { name: 'FechaDocumento' },
                { name: 'NroResolucion' },
                { name: 'FechaVencimiento' },
                { name: 'DiasVencimiento' },
                { name: 'Concepto' },
                { name: 'Capitacion' },
                { name: 'Poblacion' },
                { name: 'VlrUPC' },
                { name: 'PorcentajeUPC' },
                { name: 'PeriodoDesde' },
                { name: 'PeriodoHasta' },
                { name: 'Tratamiento' },
                { name: 'CAS' },
                { name: 'Paciente' },
                { name: 'VlrTotal' },
                { name: 'VlrIVA' },
                { name: 'VlrCuotaModeradora' },
                { name: 'VlrCopagos' },
                { name: 'VlrDescuentos' },
                { name: 'VlrNeto' },
                { name: 'YaRadicada' },
                { name: 'FechaRadicada' },
                { name: 'Anulada' },
                { name: 'UsuarioAnula' },
                { name: 'MotivoAnula' },
                { name: 'FechaAnula' },
                { name: 'YaRecaudoInstitucional' },
                { name: 'idComprobanteRecaudoInstitucional' },
                { name: 'UsuarioFactura' },
                { name: 'FechaMov' },
                { name: 'Debito' },
                { name: 'Credito' }
            ]
        }, cfg));
    }
});
new StoreLegalizacionesxCAS();



