/*
* @category    Store Profesionales x Plantillas HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridPlantillasHCxProfesional = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridPlantillasHCxProfesional.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridPlantillasHCxProfesional',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales201601.php',
                method: 'POST'
            }),
            baseParams:{
                task: "GRID_PLANTILLAHC"
            },
            autoload: false,
                reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
				{
                    name: 'IdRegistro'
                },
                {
                    name: 'Profesional'
                },
                {
                    name: 'PlantillaHC'
                },
                {
                    name: 'NomPlantilla'
                }
            ]),
            sortInfo:{field: 'NomPlantilla', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridPlantillasHCxProfesional();

