/*
* @category    Store Procedimientos a Programar x Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfesionalesProgramarProcedimientos = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfesionalesProgramarProcedimientos.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfesionalesProgramarProcedimientos',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesionales/controlador_profesionales.php',
                method: 'POST'
            }),
            baseParams:{task: "GRID_PROCEDIMIENTOS"},
            autoLoad: false,
            groupField: 'TipoEstudio',
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'idProfesional'
                },
                {
                    name: 'IdProced'
                },
                {
                    name: 'TipoEstudio'
                },
                {
                    name: 'CodProced'
                },
                {
                    name: 'CUPSCodigo'
                },
                {
                    name: 'DesProced'
                }
            ]),
            sortInfo:{field: 'DesProced', direction: "ASC"}
        }, cfg));
    }
});
new StoreGridProfesionalesProgramarProcedimientos();

