/*
* @category    Store Consultorios x Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProfeSolicitantes = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProfeSolicitantes.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProfeSolicitantes',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/profesol/controlador_profesol.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR"},
            autoload: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {
                    name: 'Codigo'
                },
                {
                    name: 'Descripcion'
                },
                {
                    name: 'Especialidad'
                },
                {
                    name: 'Direccion'
                },
                {
                    name: 'Telefono'
                },
                {
                    name: 'Usuario'
                },
                {
                    name: 'FechaAct'
                }
            ])
        }, cfg));
    }
});
new StoreGridProfeSolicitantes();

