/*
* @category    Store Tarifas x Clientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProgramas = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProgramas.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProgramas',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/programas/controlador_programas.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_PROGRAMAS"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdPrograma'},
                {name: 'Descripcion'},
                {name: 'Finalidad'},
                {name: 'Exento'},
                {name: 'Activo'}
            ])
        }, cfg));
    }
});
new StoreGridProgramas();

