/*
* @category    Store Tipo Atencion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridProgramasServicios = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridProgramasServicios.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridProgramasServicios',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/programas/controlador_programas.php',
                method: 'POST'
            }),
            baseParams:{task: "LISTAR_SERVICIOS"},
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                {name: 'IdPrograma'},
                {name: 'Programa'},
                {name: 'Estadio'},
                {name: 'Genero'},
                {name: 'IdProced'},
                {name: 'Procedimiento'},
                {name: 'PeriodoDias'},
                {name: 'Ingreso'},
                {name: 'Obligatorio'}
            ])
        }, cfg));
    }
});
new StoreGridProgramasServicios();

