/*
* @category    Store Grid Estudios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridEstudios = Ext.extend(Ext.data.GroupingStore, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridEstudios.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridEstudios',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/agendas/controlador_asignarcitas.php',
                method: 'POST'
            }),
            groupField: 'nomPaciente',
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'CAS' },
                { name: 'PrefijoNroEstudio' },
                { name: 'SubNroEstudioINT' },
                { name: 'NroAutorizacion' },
                { name: 'FechaEstudio' },
                { name: 'ConsecutivoDetalle' },
                { name: 'CodProcedimiento' },
                { name: 'DescProcedimiento' },
                { name: 'YaCerrado' },
                { name: 'FechaCerrado' },
                { name: 'Paciente' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'FecNac' },
                { name: 'Genero' },
                { name: 'Direccion' },
                { name: 'Zona' },
                { name: 'Telefono' },
                { name: 'Telefono1' },
                { name: 'Email' },
                { name: 'NroServicio' },
                { name: 'NroCAS_Origen' },
                { name: 'Origen' },
                { name: 'Prestador' },
                { name: 'Sede' },
                { name: 'IPS' },
                { name: 'Consultorio' },
                { name: 'Cliente' },
                { name: 'Plan' },
                { name: 'Subplan' },
                { name: 'Contrato' },
                { name: 'Examen' },
                { name: 'Lote' },
                { name: 'FechaToma' },
                { name: 'ProfesionalSolicitante' },
                { name: 'TipoAfiliacion' },
                { name: 'TipoAfiliado' },
                { name: 'Parentesco' },
                { name: 'RangoSalarial' },
                { name: 'EstadoListado' },
                { name: 'EdadPaciente' },
                { name: 'DeptoMuniciPaciente' },
                { name: 'PorCopagos' },
                { name: 'VlrEstudios' },
                { name: 'VlrInsumos' },
                { name: 'VlrMedicamentos' },
                { name: 'VlrIVA' },
                { name: 'VlrICA' },
                { name: 'VlrCuotaModeradoraEstudios' },
                { name: 'VlrCopagosEstudios' },
                { name: 'VlrCopagosInsumos' },
                { name: 'VlrCopagosMedicamentos' },
                { name: 'VlrDescuentos' },
                { name: 'VlrNeto' },
                { name: 'VlrRetencion' },
                { name: 'MarcaExenta' },
                { name: 'YaLegalizado' },
                { name: 'FechaLegaliza' },
                { name: 'TipoLegalizacion' },
                { name: 'UsuarioLegaliza' },
                { name: 'YaEntregado' },
                { name: 'FechaEntregado' },
                { name: 'UsrEntregado' },
                { name: 'YaFacturadoEnt' },
                { name: 'Capitacion' },
                { name: 'CodEstadoReg' },
                { name: 'EstadoRegistro' },
                { name: 'Programa' },
                { name: 'Finalidad' },
                { name: 'TipoAtencion' },
                { name: 'FacturarParticular' },
                { name: 'FacturarCopagos' },
                { name: 'CopagoDigitado' },
                { name: 'vlrCuotaModeradoraIndicada' },
                { name: 'MaxCopago' },
                { name: 'Exento' },
                { name: 'Tutela' },
                { name: 'ResumenHC' },
                { name: 'DiagPpal' },
                { name: 'DiagRel1' },
                { name: 'DiagRel2' },
                { name: 'DiagRel3' },
                { name: 'nomCliente' },
                { name: 'nomPaciente' }
            ]),
            sortInfo:{field: 'FechaEstudio', direction: "DESC"}
        }, cfg));
    }
});
new StoreGridHistorialLegalizaciones();
