/*
* @category    Store Grid Historial Suministros PyP
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridSuministrosPyP = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridSuministrosPyP.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridSuministrosPyP',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/asistencial/saludpyp.php',
                method: 'POST'
            }),
            baseParams: {
                task: "VerHistorialSuministros"
            },
            autoLoad: false,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'idConsecutivo' },
                { name: 'Paciente' },
                { name: 'CAS' },
                { name: 'Fecha' },
                { name: 'Descripcion' }
            ])
        }, cfg));
    }
});
new StoreGridSuministrosPyP();
