/*
* @category    Store Grid Transcribir Laboratorio Clinico
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

StoreGridTrascribirRx = Ext.extend(Ext.data.Store, {
    constructor: function(cfg) {
        cfg = cfg || {};
        StoreGridTrascribirRx.superclass.constructor.call(this, Ext.apply({
            storeId: 'StoreGridTrascribirRx',
            proxy: new Ext.data.HttpProxy({
                url: '../../controlador/transcriberx/controlador_transcriberx.php',
                method: 'POST'
            }),
            baseParams: {
                task: "LISTAR_TRANSCRIBIR_RX"
            },
            autoLoad: true,
            reader: new Ext.data.JsonReader({
                root: 'results',
                totalProperty: 'total',
                id: 'id'
            },
            [
                { name: 'Prestador' },
                { name: 'Sede' },
                { name: 'IPS' },
                { name: 'Paciente' },
                { name: 'CAS' },
                { name: 'ConsecutivoHC' },
                { name: 'idCliente' },
                { name: 'idPlan' },
                { name: 'idSubPlan' },
                { name: 'idContrato' },
                { name: 'FechaCita' },
                { name: 'Profesional' },
                { name: 'Cliente' },
                { name: 'ConsecutivoDetalle' },
                { name: 'IdProcedimiento' },
                { name: 'CodProcedimiento' },
                { name: 'Actividad' },
                { name: 'Agendado' },
                { name: 'YaLegalizado' },
                { name: 'HoraAgenda' },
                { name: 'HoraAtencion' },
                { name: 'FechaLegaliza' },
                { name: 'TipoLegalizacion' },
                { name: 'TipDoc' },
                { name: 'Documento' },
                { name: 'PrimerApellido' },
                { name: 'SegundoApellido' },
                { name: 'PrimerNombre' },
                { name: 'SegundoNombre' },
                { name: 'FecNac' },
                { name: 'Edad' },
                { name: 'Genero' },
                { name: 'Direccion' },
                { name: 'Zona' },
                { name: 'Telefono' },
                { name: 'Telefono1' },
                { name: 'YaRealizado' },
                { name: 'FechaRealizado' },
                { name: 'QuienRealizo' },
                { name: 'QuienTranscribio' },
                { name: 'EstadoReg' },
                { name: 'DescEstadoReg' },
                { name: 'TipoEstudio' },
                { name: 'FormatoDosColumnas' }
            ])
        }, cfg));
    }
});
new StoreGridTrascribirRx();

